%        X         Y         Z         R
data = [...
  -86.9040   21.2190   21.2190   21.2190
  -84.5000   21.0370   21.0370   21.0370
  -80.5830   20.7400   20.7400   20.7400
  -79.0000   20.5270   20.5610   20.5130
  -77.5000   20.3920   20.1600   19.9260
  -75.6250   20.0840   19.1240   18.7960
  -74.5000   19.8370   18.2510   17.7670
  -73.3750   19.5520   17.0550   16.3950
  -71.8750   19.0940   15.2630   14.3080
  -70.3750   18.5980   13.4630   12.1940
  -68.8750   18.0420   11.7600   10.1400
  -67.3750   17.4120   10.3500    8.3320
  -65.8750   16.7360    9.1950    6.7490
  -64.3750   15.9860    8.3030    5.3820
  -62.8750   15.1980    7.5600    4.1410
  -61.3750   14.3730    6.9750    3.0350
  -59.8750   13.5330    6.5330    2.0600
  -58.3750   12.6180    6.2420    1.1900
  -58.0000   12.4160    6.1850    1.0060
  -57.6250   12.1910    6.1360    0.8150
  -57.2500   11.9580    6.0940    0.6260
  -56.8750   11.7330    6.0600    0.4490
  -56.5000   11.5080    6.0340    0.2810
  -56.1250   11.2760    6.0150    0.1150
  -55.8440   11.1080    6.0060         0
  -55.7500   11.0630    6.0040         0
  -55.3750   10.8380    6.0000         0
  -54.3750   10.2670    6.0000         0
  -53.3750    9.7510    6.0000         0
  -52.3750    9.2860    6.0000         0
  -51.3750    8.8670    6.0000         0
  -50.3750    8.4930    6.0000         0
  -49.3750    8.1580    6.0000         0
  -48.3750    7.8600    6.0000         0
  -47.3750    7.5960    6.0000         0
  -46.3750    7.3620    6.0000         0
  -45.3750    7.1570    6.0000         0
  -44.3750    6.9770    6.0000         0
  -43.3750    6.8200    6.0000         0
  -42.3750    6.6840    6.0000         0
  -41.3750    6.5660    6.0000         0
  -40.3750    6.4650    6.0000         0
  -39.3750    6.3790    6.0000         0
  -38.3750    6.3060    6.0000         0
  -37.3750    6.2450    6.0000         0
  -36.3750    6.1940    6.0000         0
  -35.3750    6.1520    6.0000         0
  -34.8750    6.1330    6.0000         0
  -34.3750    6.1170    6.0000         0
  -33.8750    6.1020    6.0000         0
  -33.3750    6.0890    6.0000         0
  -33.1250    6.0830    6.0000         0
  -32.8750    6.0770    6.0000         0
  -32.3750    6.0670    6.0000         0
  -31.8750    6.0570    6.0000         0
  -31.3750    6.0490    6.0000         0
  -30.8750    6.0420    6.0000         0
  -29.8750    6.0300    6.0000         0
  -28.8750    6.0210    6.0000         0
  -27.8750    6.0140    6.0000         0
  -26.8750    6.0090    6.0000         0
  -25.8750    6.0060    6.0000         0
  -24.8750    6.0030    6.0000         0
  -23.8750    6.0020    6.0000         0
  -22.8750    6.0010    6.0000         0
  -21.8750    6.0000    6.0000         0
   14.8375    6.0000    6.0000         0];

Fy = griddedInterpolant(data(:,1),data(:,2),'spline','none');
Fz = griddedInterpolant(data(:,1),data(:,3),'spline','none');
Fr = griddedInterpolant(data(:,1),data(:,4),'spline','none');

figure, hold on

c = lines(3);
x = linspace(data(1,1),data(end,1),100);
n = 20;
for xi = 1:length(x)
    [s1y, s1z, s2y, s2z] = tunnel_slice(Fy(x(xi)), Fz(x(xi)), Fr(x(xi)), n);
    plot3(ones(size(s1y))*x(xi),s1z,s1y,'.','color',c(1,:))
    plot3(ones(size(s2y))*x(xi),s2z,s2y,'.','color',c(2,:))
end

x = linspace(data(1,1),data(end,1),500);
for xi = 1:length(x)
    [r] = model_slice(x(xi));
    t = linspace(0,1,2*n);
    plot3(x(xi)*ones(size(t)),r*sin(t*pi/2),r*cos(t*pi/2),'.','color',c(3,:))
end

axis equal
axis tight
grid on
view(-240,20)
xlabel('x [in]');
ylabel('z [in]');
zlabel('y [in]');

function [r] = model_slice(x)

a = 5.0;
b = 4.0;
d = 1.9;
t = 0.005;
at = 3.0;
c = 2.5333;
h = 0.2375;
e = 12;
cr = 1.2;

% Define main hump based on chord and hump height. 
ma = 2*h / c;
mb = -2*h / c;
x1 = (mb*c/2 - 3*ma*c/2) / (2*(mb-ma));
r1 = -1/ma*(x1-c/4)+(d+h)/2;
R1 = sqrt(x1.^2 + (d/2-r1).^2);
 
% Calculate the tangent fillet.
R2 = cr*d;
x2 = x1 - sqrt( (R1 + R2)^2 - (R2 + d/2 - r1)^2 );
r2 = d/2 + R2;
theta = atan2(x1-x2, R2 + d/2 - r1);
xt = x1 - R1 * sin(theta);
xd = x2;

% Initialize coordinates.
r = nan(1,length(x));
 
% Ellipse prior to step.
tmp = (x > -b-a+xd) & (x <= -b-a+xd+at);
r(tmp) = (d/2 + t)*sqrt(1-(x(tmp) + b - xd).^2./a.^2);
 
% Ellipse after step.
tmp = (x > -b-a+xd+at) & (x <= -b+xd);
r(tmp) = d/2*sqrt(1-(x(tmp) + b - xd).^2./a.^2);
 
% Forebody
tmp = (x > -b+xd) & (x <= xd);
r(tmp) = d/2;
 
% Fillet
tmp = (x > xd) & (x <= xt);
r(tmp) = r2 - sqrt(R2.^2 - (x(tmp)-x2).^2);
 
% Hump
tmp = (x > xt) & (x <= c);
r(tmp) = r1 + sqrt(R1.^2 - (x(tmp)-x1).^2);
 
% Afterbody
tmp = (x > c) & (x <= c+e);
r(tmp) = d/2;

end


function [s1y, s1z, s2y, s2z] = tunnel_slice(y, z, r, n)

% Total length of segment 1.
T1l = y - r + pi * r / 4;
T1b = (y - r) / T1l;
 
% Parameterize segment 1.
T1 = linspace(0,1,n);
 
% Initial straight section.
T11 = T1(T1<T1b);
z11 = z * ones(size(T11));
y11 = (y-r) * T11 /  T1b;

% Connection , if it exists.
T12 = T1(T1==T1b);
z12 = z * ones(size(T12));
y12 = (y-r) * ones(size(T12));

% Curved section.
T13 = T1(T1>T1b);
z13 = z - r + r * cos((T13-T1b)/(1-T1b) * pi/4);
y13 = y - r + r * sin((T13-T1b)/(1-T1b) * pi/4);
 
% Combine.
s1y = [y11 y12 y13];
s1z = [z11 z12 z13];
 
% Total length of segment 2.
T2l = z - r + pi * r / 4;
T2b = (z - r) / T2l;
 
% Parameterize segment 1.
T2 = linspace(0,1,n);
 
% Initial straight section.
T21 = T2(T2<T2b);
z21 = (z-r) * T21 / T2b;
y21 = y * ones(size(T21));

% Connection , if it exists.
T22 = T2(T2==T2b);
z22 = (z-r) * ones(size(T22));
y22 = y * ones(size(T22));
 
% Curved section.
T23 = T2(T2>T2b);
z23 = z - r + r * sin((T23-T2b)/(1-T2b) * pi/4);
y23 = y - r + r * cos((T23-T2b)/(1-T2b) * pi/4);
 
% Combine.
s2y = [y21 y22 y23];
s2z = [z21 z22 z23];

end
